#include "maindefs.h"
#include "sleep.h"
#include "xbee.h"
#include "timers.h"
#include "led_driver.h"
#include <delays.h>

void sleep() {
    timer0_enable();
}

void sleep_enable() {
#ifdef _BASE_STATION
    led_driver_data(0);
    led_driver_data(0);
#endif
#ifdef _REMOTE
    led_driver_data(0);
    led_driver_data(0);
    xbee_sleep();
#endif
    _asm
    sleep
    _endasm
}

void wake() {
#ifdef _BASE_STATION
    led_driver_num(BASE_STATION_ADDRESS);
#endif
#ifdef _REMOTE
    xbee_wake();
    Delay10KTCYx(2);    // Give some time for the radio to wake up
    led_driver_show_last();
#endif
    timer0_disable();
}
